module net.BurtonRadons.dedit.highlight.msasm;

import net.BurtonRadons.dedit.main;
import std.path;
import std.string;
import std.ctype;

alias std.ctype.isdigit isdigit;

/** The Microsoft Assembly highlighter. */
class MSAsm_Highlighter : SyntaxHighlighter
{
    version (X86)
    {
        char [] [] special =
        [
            "al", "ah", "ax", "eax", "bl", "bh", "bx", "ebx",
            "cl", "ch", "cx", "ecx", "dl", "dh", "dx", "edx",
            "bp", "ebp", "sp", "esp", "di", "edi",  "si", "esi",
            "es", "cs", "ss", "ds", "gs", "fs",
            "cr0", "cr2", "cr3", "cr4",
            "dr0", "dr1", "dr2", "dr3", "dr6", "dr7",
            "tr3", "tr4", "tr5", "tr6", "tr7",
            "st",
            "mm0", "mm1", "mm2", "mm3", "mm4", "mm5", "mm6", "mm7",
        ];

        char [] [] reserved =
        [
            "align", "byte", "call", "db", "dd", "de", "df",
            "di", "dl", "double", "ds", "dword", "even", "extended", "far",
            "float", "int", "lock", "mov", "naked", "near", "offset", "pc",
            "pop", "ptr", "rep", "repe", "repne", "repnz", "repz", "seg",
            "short", "word",

            "include", "ifdef", "else", "endif", "segment", "use32", "public",
            "extern", "equ", "begcode", "endcode", "page", "title", "macro",
            "endm", "equ", "endp", "end",

            "aaa", "aad", "aam", "aas", "adc", "add", "addpd", "addps", "addsd",
            "addss", "and", "andnpd", "andnps", "andpd", "andps", "arpl",
            "bound", "bsf", "bsr", "bswap", "bt", "btc", "btr", "bts", "call",
            "cbw", "cdq", "clc", "cld", "clflush", "cli", "clts", "cmc", "cmova",
            "cmovae", "cmovb", "cmovbe", "cmovc", "cmove", "cmovg", "cmovge",
            "cmovl", "cmovle", "cmovna", "cmovnae", "cmovnb", "cmovnbe", "cmovnc",
            "cmovne", "cmovng", "cmovnge", "cmovnl", "cmovnle", "cmovno",
            "cmovnp", "cmovns", "cmovnz", "cmovo", "cmovp", "cmovpe", "cmovpo",
            "cmovs", "cmovz", "cmp", "cmppd", "cmpps", "cmps", "cmpsb", "cmpsd",
            "cmpss", "cmpsw", "cmpxch8b", "cmpxchg", "comisd", "comiss", "cpuid",
            "cvtdq2pd", "cvtdq2ps", "cvtpd2dq", "cvtpd2pi", "cvtpd2ps",
            "cvtpi2pd", "cvtpi2ps", "cvtps2dq", "cvtps2pd", "cvtps2pi",
            "cvtsd2si", "cvtsd2ss", "cvtsi2sd", "cvtsi2ss", "cvtss2sd",
            "cvtss2si", "cvttpd2dq", "cvttpd2pi", "cvttps2dq", "cvttps2pi",
            "cvttsd2si", "cvttss2si", "cwd", "cwde", "da", "daa", "das", "db",
            "dd", "de", "dec", "df", "di", "div", "divpd", "divps", "divsd",
            "divss", "dl", "dq", "ds", "dt", "dw", "emms", "enter", "f2xm1",
            "fabs", "fadd", "faddp", "fbld", "fbstp", "fchs", "fclex", "fcmovb",
            "fcmovbe", "fcmove", "fcmovnb", "fcmovnbe", "fcmovne", "fcmovnu",
            "fcmovu", "fcom", "fcomi", "fcomip", "fcomp", "fcompp", "fcos",
            "fdecstp", "fdiv", "fdivp", "fdivr", "fdivrp", "ffree", "fiadd",
            "ficom", "ficomp", "fidiv", "fidivr", "fild", "fimul", "fincstp",
            "finit", "fist", "fistp", "fisub", "fisubr", "fld", "fld1", "fldcw",
            "fldenv", "fldl2e", "fldl2t", "fldlg2", "fldln2", "fldpi", "fldz",
            "fmul", "fmulp", "fnclex", "fninit", "fnop", "fnsave", "fnstcw",
            "fnstenv", "fnstsw", "fpatan", "fprem", "fprem1", "fptan", "frndint",
            "frstor", "fsave", "fscale", "fsetpm", "fsin", "fsincos", "fsqrt",
            "fst", "fstcw", "fstenv", "fstp", "fstsw", "fsub", "fsubp", "fsubr",
            "fsubrp", "ftst", "fucom", "fucomi", "fucomip", "fucomp", "fucompp",
            "fwait", "fxam", "fxch", "fxrstor", "fxsave", "fxtract", "fyl2x",
            "fyl2xp1", "hlt", "idiv", "imul", "in", "inc", "ins", "insb", "insd",
            "insw", "int", "into", "invd", "invlpg", "iret", "iretd", "ja", "jae",
            "jb", "jbe", "jc", "jcxz", "je", "jecxz", "jg", "jge", "jl", "jle",
            "jmp", "jna", "jnae", "jnb", "jnbe", "jnc", "jne", "jng", "jnge",
            "jnl", "jnle", "jno", "jnp", "jns", "jnz", "jo", "jp", "jpe", "jpo",
            "js", "jz", "lahf", "lar", "ldmxcsr", "lds", "lea", "leave", "les",
            "lfence", "lfs", "lgdt", "lgs", "lidt", "lldt", "lmsw", "lock",
            "lods", "lodsb", "lodsd", "lodsw", "loop", "loope", "loopne",
            "loopnz", "loopz", "lsl", "lss", "ltr", "maskmovdqu", "maskmovq",
            "maxpd", "maxps", "maxsd", "maxss", "mfence", "minpd", "minps",
            "minsd", "minss", "mov", "movapd", "movaps", "movd", "movdq2q",
            "movdqa", "movdqu", "movhlps", "movhpd", "movhps", "movlhps",
            "movlpd", "movlps", "movmskpd", "movmskps", "movntdq", "movnti",
            "movntpd", "movntps", "movntq", "movq", "movq2dq", "movs", "movsb",
            "movsd", "movss", "movsw", "movsx", "movupd", "movups", "movzx",
            "mul", "mulpd", "mulps", "mulsd", "mulss", "neg", "nop", "not",
            "or", "orpd", "orps", "out", "outs", "outsb", "outsd", "outsw",
            "packssdw", "packsswb", "packuswb", "paddb", "paddd", "paddq",
            "paddsb", "paddsw", "paddusb", "paddusw", "paddw", "pand", "pandn",
            "pavgb", "pavgw", "pcmpeqb", "pcmpeqd", "pcmpeqw", "pcmpgtb",
            "pcmpgtd", "pcmpgtw", "pextrw", "pinsrw", "pmaddwd", "pmaxsw",
            "pmaxub", "pminsw", "pminub", "pmovmskb", "pmulhuw", "pmulhw",
            "pmullw", "pmuludq", "pop", "popa", "popad", "popf", "popfd", "por",
            "prefetchnta", "prefetcht0", "prefetcht1", "prefetcht2", "psadbw",
            "pshufd", "pshufhw", "pshuflw", "pshufw", "pslld", "pslldq", "psllq",
            "psllw", "psrad", "psraw", "psrld", "psrldq", "psrlq", "psrlw",
            "psubb", "psubd", "psubq", "psubsb", "psubsw", "psubusb", "psubusw",
            "psubw", "punpckhbw", "punpckhdq", "punpckhqdq", "punpckhwd",
            "punpcklbw", "punpckldq", "punpcklqdq", "punpcklwd", "push", "pusha",
            "pushad", "pushf", "pushfd", "pxor", "rcl", "rcpps", "rcpss", "rcr",
            "rdmsr", "rdpmc", "rdtsc", "rep", "repe", "repne", "repnz", "repz",
            "ret", "retf", "rol", "ror", "rsm", "rsqrtps", "rsqrtss", "sahf",
            "sal", "sar", "sbb", "scas", "scasb", "scasd", "scasw", "seta",
            "setae", "setb", "setbe", "setc", "sete", "setg", "setge", "setl",
            "setle", "setna", "setnae", "setnb", "setnbe", "setnc", "setne",
            "setng", "setnge", "setnl", "setnle", "setno", "setnp", "setns",
            "setnz", "seto", "setp", "setpe", "setpo", "sets", "setz", "sfence",
            "sgdt", "shl", "shld", "shr", "shrd", "shufpd", "shufps", "sidt",
            "sldt", "smsw", "sqrtpd", "sqrtps", "sqrtsd", "sqrtss", "stc", "std",
            "sti", "stmxcsr", "stos", "stosb", "stosd", "stosw", "str", "sub",
            "subpd", "subps", "subsd", "subss", "sysenter", "sysexit", "test",
            "ucomisd", "ucomiss", "ud2", "unpckhpd", "unpckhps", "unpcklpd",
            "unpcklps", "verr", "verw", "wait", "wbinvd", "wrmsr", "xadd",
            "xchg", "xlat", "xlatb", "xor", "xorpd", "xorps ",

            "pavgusb", "pf2id", "pfacc", "pfadd", "pfcmpeq", "pfcmpge", "pfcmpgt",
            "pfmax", "pfmin", "pfmul", "pfnacc", "pfpnacc", "pfrcp", "pfrcpit1",
            "pfrcpit2", "pfrsqit1", "pfrsqrt", "pfsub", "pfsubr", "pi2fd",
            "pmulhrw", "pswapd ",
        ];
    }
    else
    {
        char [] [] reserved;
        char [] [] special;
    }

    const char [] symbols = "()[]<>{}:;=!%^&*-+|/.,$";

    static this ()
    {
        list ~= new MSAsm_Highlighter ();
    }

    override char [] name () { return "Assembly, Microsoft"; }
    override char [] exts () { return "*.asm"; }

    override float match (char [] filename, char [] [] data)
    {
        if (!icmp (getExt (filename), "asm"))
            return 1;
        return 0;
    }

    bit isSymbol (char f)
    {
        for (int c; c < symbols.length; c ++)
            if (f == symbols [c])
                return true;

        return false;
    }

    char [] isKeyword (char *c, int n, char [] [] list)
    {
        for (int d; d < list.length; d ++)
        {
            char [] r = list [d];

            if (n >= r.length && c [0 .. r.length] == r
            && (n < r.length + 1 || (!isalnum (c [r.length]) && c [r.length != '_'])))
                return r;
        }

        return null;
    }

    bit isIdentifierStart (char f)
    {
        return isalpha (f) || f == '_';
    }

    bit isIdentifierBody (char f)
    {
        return isalnum (f) || f == '_';
    }
    
    struct LineInfo
    {
        char code; /**< Current syntax highlighting code. */
        char open;
            /**< Current major type:
               * <ul>
               * <li>'*' - multiline comment.
               * <li>'"' - double-quoted std.string.
               * <li>"'" - single-quoted std.string.
               * <li>'i' - identifier.
               * <li>'/' - single-line comment.
               * <li>'#' - number.
               * </ul>
               */
    }

    /* We take the open code followed by the mode. */
    override int extraSize () { return LineInfo.size; }

    override void highlight (char [] line, char [] high, void *lastp, void *nextp)
    {
        LineInfo *last = (LineInfo *) lastp;
        LineInfo *next = (LineInfo *) nextp;
        char *c, h, e;
        char open;
        char code;

        if (last !== null)
        {
            open = last.open;
            code = last.code;
        }

        c = line;
        h = high;
        e = c + line.length;

        while (c < e)
        {
            int n = (int) (e - c);
            char f = *c;
            char [] r;

        restart:
            if (open == '*')
            {
                if (n > 1 && c [0] == '*' && c [1] == '/')
                {
                    *h ++ = code;
                    *h ++ = code;
                    code = 0;
                    open = 0;
                    c += 2;
                }
                else
                    goto def;
            }
            else if (open == '"')
            {
                if (c [0] == '\\')
                {
                    *h ++ = code;
                    c ++;
                    if (c < e)
                        goto def;
                    goto dun;
                }
                else if (c [0] == '"')
                {
                    *h ++ = code;
                    code = open = 0;
                    c ++;
                }
                else
                    goto def;
            }
            else if (open == '\'')
            {
                if (c [0] == '\'')
                {
                    *h ++ = code;
                    code = open = 0;
                    c ++;
                }
                else
                    goto def;
            }
            else if (open == 'i')
            {
                if (isalnum (f) || f == '_')
                    goto def;
                open = code = 0;
                goto restart;
            }
            else if (open == '/')
                goto def;
            else if (open == '#')
            {
                if (isdigit (f) || f == 'x' || f == 'X' || f == '.' || f == 'e' || f == 'E'
                 || f == 'a' || f == 'b' || f == 'c' || f == 'd' || f == 'e' || f == 'f'
                 || f == 'A' || f == 'B' || f == 'C' || f == 'D' || f == 'E' || f == 'F'
                 || f == 'l' || f == 'L')
                    goto def;
                else
                {
                    code = open = 0;
                    goto restart;
                }
            }
        /* open == 0 from here on */
            else if (f == ';')
            {
                open = '/', code = '*';
                goto def;
            }
            else if (f == '\"')
            {
                open = code = '"';
                goto def;
            }
            else if (f == '\'')
            {
                open = '\''; 
                code = '"';
                goto def;
            }
            else if (isdigit (f) || (f == '.' && (n == 1 || isdigit (c [1]))))
            {
                open = code = '#';
                goto def;
            }
            else
            {
                if (isSymbol (f))
                {
                    *h ++ = 's', c ++;
                    goto dun;
                }

                if (isIdentifierStart (f))
                {
                    char [] seg;
                    int e;

                    for (e = 1; e < n && isIdentifierBody (c [e]); e ++)
                        {}
                    seg = std.string.tolower (c [0 .. e]);

                    char [] [] list = reserved;

                    for (int f; f < list.length; f ++)
                        if (list [f] == seg)
                        {
                            char [] r = list [f];

                            h [0 .. r.length] = "r";
                            h += r.length;
                            c += r.length;
                            if (r == "title" || r == "include")
                                open = '/', code = '*';
                            goto dun;
                        }

                    list = special;

                    for (int f; f < list.length; f ++)
                        if (list [f] == seg)
                        {
                            char [] r = list [f];

                            h [0 .. r.length] = "m";
                            h += r.length;
                            c += r.length;
                            goto dun;
                        }

                    h [0 .. e] = "i";
                    h += e;
                    c += e;
                    goto dun;
                }
                else
                    goto def;
            }

        dun:
            continue;
        def:
            *h ++ = code;
            c += 1;
        }

        if (open == 'i' || open == '/' || open == '#')
            open = 0;

        next.open = open;
        next.code = code;
    }
}

